#!/bin/bash

# Slurm job options (job-name, compute nodes, job time)
#SBATCH --job-name=name_of_job_on_slurm
#SBATCH --time=0:06:0
#SBATCH --nodes=2
#SBATCH --tasks-per-node=128
#SBATCH --cpus-per-task=1
#SBATCH --account=n02-RECAP
#SBATCH --partition=standard
#SBATCH --qos=short
#SBATCH --mem=0
#SBATCH --reservation=shortqos

export icon_dir=/work/n02/n02/rherbe/ICON/icon-hammoz/icon

module load cray-netcdf
module load cray-hdf5
module unload craype-network-ofi
module unload cray-mpich
module load craype-network-ucx
module load cray-mpich-ucx
module load libfabric
module load cpe/21.03
module load atp

export ATP_ENABLED=1

export LD_LIBRARY_PATH=$CRAY_LD_LIBRARY_PATH:$LD_LIBRARY_PATH

cd $icon_dir/run
./exp.ICON-HAM_archer2_example.run
